<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'email', 'email_verified_at', 'country_code', 'phone', 'phone_verified_at', 'password', 'image', 'is_active', 'register_from', 'provider', 'provider_id', 'countries_id', 'languages', 'intersts', 'job_title', 'birthday', 'gender', 'country_id', 'city_id', 'address', 'nickname', 'total_wallets', 'total_rates', 'total_points');

    public function notifications()
    {
        return $this->belongsToMany('App\Models\Notification');
    }

    public function favourites()
    {
        return $this->hasMany('App\Models\Favourite');
    }

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function points()
    {
        return $this->hasMany('App\Models\Point');
    }

    public function wallets()
    {
        return $this->hasMany('App\Models\Wallet');
    }

    public function rates()
    {
        return $this->hasMany('App\Models\Rate');
    }

    public function rates()
    {
        return $this->morphMany('App\Models\Rate', 'rateable');
    }

}